#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

from configparser import ConfigParser, ExtendedInterpolation


class Config(object):

    def __init__(self, fileName):
        self.fileName = fileName
        self.config = ConfigParser(interpolation = ExtendedInterpolation())
        self.config.read(fileName)        

    def loadSection(self, sectionName):
        section = self.config[sectionName]
        return section

# Test
#c = Config("vos_ts.conf")
#params = c.loadSection("file_grouper")
#print(params.getint("min_num_files"))
#print(eval(params["max_dir_size"]))
