#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#
#
#
# Example of JSON object obtained with "eeadm pool list --json":
#
# {
#    "id": "c42ba7c9-1ec7-43a3-91af-b735a81ebbb2",
#    "name": "pl_generic_rw_01",
#    "media_restriction": "^.{8}$",
#    "capacity": 130982137036800,
#    "used_space": 61111860723712,
#    "free_space": 69870276313088,
#    "reclaimable_space": 263958922781,
#    "active_space": 60847901800931,
#    "non_appendable_space": 0,
#    "num_of_tapes": 15,
#    "format_class": "default",
#    "library_name": "tape_ia2_SA",
#    "library_id": "bc4bbe3f-b670-46e2-bba9-3fbc1fc2ce52",
#    "nodegroup_name": "G0",
#    "device_type": "LTO",
#    "worm": "no",
#    "fill_policy": "Default",
#    "owner": "System",
#    "mount_limit": 0,
#    "low_space_warning_enable": false,
#    "low_space_warning_threshold": 0,
#    "no_space_warning_enable": false,
#    "mode": "normal"
#  }
#

class TapePool(object):
    
    def __init__(self):
        self.id = None
        self.name = None
        self.mediaRestriction = None
        self.capacity = None
        self.usedSpace = None
        self.freeSpace = None
        self.reclaimableSpace = None
        self.activeSpace = None
        self.nonAppendableSpace = None
        self.numOfTapes = None
        self.formatClass = None
        self.libraryName = None
        self.libraryId = None
        self.nodeGroupName = None
        self.deviceType = None
        self.worm = None
        self.fillPolicy = None
        self.owner = None
        self.mountLimit = None
        self.lowSpaceWarningEnable = None
        self.lowSpaceWarningThreshold = None
        self.noSpaceWarningEnable = None
        self.mode = None
        
    """
    Getters
    """
    
    def getId(self):
        return self.id
    
    def getName(self):
        return self.name
    
    def getMediaRestriction(self):
        return self.mediaRestriction
    
    def getCapacity(self):
        return self.capacity
    
    def getUsedSpace(self):
        return self.usedSpace
    
    def getFreeSpace(self):
        return self.freeSpace
    
    def getReclaimableSpace(self):
        return self.reclaimableSpace
    
    def getActiveSpace(self):
        return self.activeSpace
    
    def getNonAppendableSpace(self):
        return self.nonAppendableSpace
    
    def getNumOfTapes(self):
        return self.numOfTapes
    
    def getFormatClass(self):
        return self.formatClass
    
    def getLibraryName(self):
        return self.libraryName
    
    def getLibraryId(self):
        return self.libraryId
    
    def getNodeGroupName(self):
        return self.nodeGroupName
    
    def getDeviceType(self):
        return self.deviceType
    
    def worm(self):
        return self.worm
    
    def getFillPolicy(self):
        return self.fillPolicy
    
    def getOwner(self):
        return self.owner
    
    def getMountLimit(self):        
        return self.mountLimit
    
    def lowSpaceWarningEnable(self):
        return self.lowSpaceWarningEnable
    
    def getLowSpaceWarningThreshold(self):
        return self.lowSpaceWarningThreshold
    
    def noSpaceWarningEnable(self):
        return self.noSpaceWarningEnable
    
    def getMode(self):
        return self.mode
