import os

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector


class JobAMQPServer(AMQPServer):

    def __init__(self, host, port, queue):
        self.type = "job"
        config = Config("vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"],
                                  self.params["password"],
                                  self.params["host"],
                                  self.params.getint("port"),
                                  self.params["db"])
        self.jobId = None
        self.jobPhase = None
        super(JobAMQPServer, self).__init__(host, port, queue)

    def execute_callback(self, requestBody):
        # 'requestType' attribute is mandatory
        if "requestType" not in requestBody:
            response = { "responseType": "ERROR",
                         "errorCode": 1, 
                         "errorMsg": "Malformed request, missing parameters." }
        elif requestBody["requestType"] == "JOB_LIST":
            self.dbConn.connect()
            result = self.dbConn.listActiveJobs()
            self.dbConn.disconnect()
            response = { "responseType": "LST_DONE", "jobList": result }
        elif requestBody["requestType"] == "JOB_BY_PHASE":
            self.jobPhase = requestBody["jobPhase"]
            self.dbConn.connect()
            result = self.dbConn.listJobsByPhase(self.jobPhase)
            self.dbConn.disconnect()
            response = { "responseType": "LST_BY_PHASE_DONE", "jobList": result }
        elif requestBody["requestType"] == "JOB_INFO":
            self.jobId = requestBody["jobId"]
            self.dbConn.connect()
            result = self.dbConn.getJobInfo(self.jobId)
            self.dbConn.disconnect()
            response = { "responseType": "LST_INFO_DONE", "jobInfo": result }
        elif requestBody["requestType"] == "JOB_RESULTS":
            self.jobId = requestBody["jobId"]
            self.dbConn.connect()
            result = self.dbConn.getJobResults(self.jobId)
            self.dbConn.disconnect()
            response = { "responseType": "LST_RESULTS_DONE", "jobResults": result }
        else:
            response = { "responseType": "ERROR",
                         "errorCode": 2,
                         "errorMsg": "Unkown request type." }
        return response
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(JobAMQPServer, self).run()
