import os
import sys


class SystemUtils(object):

    def __init__(self):
        pass

    def userInfo(self, username):
        """Parses '/etc/passwd' and get returns user, uid and gid associated to
           a username."""
        fp = open("/etc/passwd", 'r')
        for line in fp:
            info = line.split(':')
            user = info[0]
            uid = int(info[2])
            gid = int(info[3])
            if user == username:
                fp.close()
                return [ user, uid, gid ]
        fp.close()
        return False

    def setDefaultPerms(self, username):
        info = self.userInfo(username)

    def scanRecursive(self, path):
        dirList = []
        fileList = []
        #if os.path.isfile(path):
        #    p = path
        #    while p != '/':
        #        p = os.path.dirname(p)
        #        dirList.append(p)
        #    dirList.reverse()
        #    fileList.append([os.path.abspath(path)])
        #    return [ dirList, fileList ]
        for folder, subfolders, files in os.walk(path, topdown = True):
            cwd = os.path.basename(folder)
            if folder != path:
                parent = os.path.dirname(folder)
                dirList.append(parent + '/' + cwd)
                i = 0
                for f in files:
                    files[i] = parent + '/' + cwd + '/' + f
                    i += 1
                fileList.append(files)
        return [ dirList, fileList ]
    
    # Scan is performed only on the first level!
    def scan(self, path):
        dirList = []
        fileList = []
        elementList = os.listdir(path)
        for el in elementList:
            elPath = path + '/' + el
            if os.path.isdir(elPath):
                dirList.append(el)
            elif os.path.isfile(elPath):
                fileList.append(el)
            else:
                sys.exit("FATAL: invalid file/dir.")
        return [ dirList, fileList ]

# Test
#sysUtils = SystemUtils()
#info = sysUtils.userInfo("cristiano")
#print(info)
