import time
import os

from config import Config
from job_handler import JobHandler
from job_scheduler import JobScheduler


class TransferService(object):

    def __init__(self):
        config = Config("vos_ts.conf")
        self.params = config.loadSection("amqp")
        self.jobHandler = JobHandler(self.params["host"], self.params.getint("port"))
        self.jobScheduler = JobScheduler()

        # PullToVOSpace (via REST API)
        self.jobHandler.addAMQPServer('start', 'start_job_queue')
        self.jobHandler.addAMQPServer('poll', 'poll_job_queue')
        self.jobHandler.addAMQPServer('abort', 'abort_job_queue')

        # PushToVOSpace (via vos_data, the 'unofficial' command line client)
        self.jobHandler.addAMQPServer('store', 'store_job_queue')       
        
        # Import
        self.jobHandler.addAMQPServer('import', 'import_queue')
        
        # Job
        self.jobHandler.addAMQPServer('job', 'job_queue')
        
        # Storage
        self.jobHandler.addAMQPServer('storage', 'storage_queue')

    def start(self):
        self.jobScheduler.start()
        self.jobHandler.start()

ts = TransferService()
ts.start()
print("Transfer service is RUNNING...")