import json
import redis
import uuid

class RedisRPCClient(object):

    def __init__(self, host, port, db, rpcQueue):
        self.client = redis.Redis(host, port, db)
        self.rpcQueue = rpcQueue

    def call(self, request):
        requestId = uuid.uuid1().hex
        request["req_id"] = requestId
        self.client.lpush(self.rpcQueue, json.dumps(request))
        channel, response = self.client.brpop(requestId, timeout = 30)
        response = json.loads(response.decode("utf-8"))
        return response


#client = RedisRPCClient("job_cache", "testList")
#client.call()
