from XRootD import client
from XRootD.client.flags import DirListFlags
from XRootD.client.flags import StatInfoFlags
from XRootD.client.flags import OpenFlags
from pathlib import Path


myclient = client.FileSystem('root://tape_frontend')
myserver = client.FileSystem('root://transfer_node')
status, listing = myclient.dirlist('/home/tape_frontend/data/aaa/', DirListFlags.STAT)

for entry in listing:
    if entry.statinfo.flags == 16:
        src = "root://tape_frontend//home/tape_frontend/data/aaa/" + entry.name
        dest = "root://transfer_node//home/transfer_node/data/aaa/" + entry.name
        print(src, dest)

status, listing = myclient.dirlist('/home/tape_frontend/data/aaa/', DirListFlags.RECURSIVE, 0)

for entry in listing:
    if entry.statinfo.flags == 16:
        src = "root://tape_frontend//home/tape_frontend/data/aaa/" + entry.name
        dest = "root://transfer_node//home/transfer_node/data/aaa/" + entry.name
        process = client.CopyProcess()
        process.add_job(source = src, target = dest, mkdir = True, force = True)
        p = process.prepare()
        r = process.run()
        print(r, p)
    else:
        # it's a dir...
        myserver.mkdir(entry.name)

print("Transfer completed.") 
