#!/usr/bin/env python

import logging

from redis_log_handler import RedisLogHandler
from redis_rpc_server import RedisRPCServer
from db_connector import DbConnector
from config import Config


class AbortJobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "abort"
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(params["user"],
                                  params["password"],
                                  params["host"],
                                  params.getint("port"),
                                  params["db"],
                                  1,
                                  2)
        params = config.loadSection("transfer_node")
        self.storageStorePath = params["store_path"]
        params = config.loadSection("scheduling")
        self.maxPendingJobs = params.getint("max_pending_jobs")
        params = config.loadSection("logging")
        self.logger = logging.getLogger(__name__)
        logLevel = "logging." + params["log_level"]
        logFormat = params["log_format"]
        logFormatter = logging.Formatter(logFormat)
        self.logger.setLevel(eval(logLevel))
        redisLogHandler = RedisLogHandler()
        logStreamHandler = logging.StreamHandler()
        logStreamHandler.setFormatter(logFormatter)
        redisLogHandler.setFormatter(logFormatter)
        self.logger.addHandler(redisLogHandler)
        self.logger.addHandler(logStreamHandler)
        super(AbortJobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        #TODO
        # do something...
        pass

    def run(self):
        self.logger.info(f"Starting RPC server of type {self.type} [NOT IMPLEMENTED]...")
        super(AbortJobRPCServer, self).run()
