#!/usr/bin/env python

import os
import shutil
import sys


class SystemUtils(object):
    
    UNITS = {
                "B": 1,
                "KB": 1 << 10,
                "MB": 1 << 20,
                "GB": 1 << 30,
                "TB": 1 << 40,
                "PB": 1 << 50,                
            }

    def __init__(self):
        pass

    def userInfo(self, username):
        """
        Parses '/etc/passwd' and returns user, uid and gid associated to
        a given username.
        """
        fp = open("/etc/passwd", 'r')
        for line in fp:
            info = line.split(':')
            user = info[0]
            uid = int(info[2])
            gid = int(info[3])
            if user == username:
                fp.close()
                return [ user, uid, gid ]
        fp.close()
        return False

    def setDefaultPerms(self, username):
        info = self.userInfo(username)

    def scanRecursive(self, path):
        dirList = []
        fileList = []
        for folder, subfolders, files in os.walk(path, topdown = True):
            cwd = os.path.basename(folder)
            if folder != path:
                parent = os.path.dirname(folder)
                dirList.append(parent + '/' + cwd)
                i = 0
                for f in files:
                    files[i] = parent + '/' + cwd + '/' + f
                    i += 1
                fileList.append(files)
        return [ dirList, fileList ]
    
    # Scan is performed only on the first level!
    def scan(self, path):
        dirList = []
        fileList = []
        elementList = os.listdir(path)
        for el in elementList:
            elPath = path + '/' + el
            if os.path.isdir(elPath):
                dirList.append(el)
            elif os.path.isfile(elPath):
                fileList.append(el)
            else:
                sys.exit("FATAL: invalid file/dir.")
        return [ dirList, fileList ]
    
    def getSize(self, path):
        """
        If 'path' is a file returns the file size in bytes,
        if 'path' is a directory it returns the total size of the dir,
        in all the other cases it returns -1
        """
        size = 0
        if os.path.isfile(path):
            size = os.path.getsize(path)    
        elif os.path.isdir(path):            
            for folder, subfolders, files in os.walk(path, topdown = True):
                cwd = os.path.basename(folder)
                parent = os.path.dirname(folder)
                size += os.path.getsize(folder)
                for file in files:
                    size += os.path.getsize(parent + '/' + cwd + '/' + file)
        else:
            size = -1
        return size

    def getFileSystemSize(self, path):
        """
        Returns a named tuple with usage statistcs in the format
        (total, used, free):
        - total: total space available in bytes
        - used: used space in bytes
        - free: free space in bytes
        """
        return shutil.disk_usage(path)

    def convertSizeToBytes(self, sizeStr):
        size = int(sizeStr.split()[0])
        unit = sizeStr.split()[1]
        if unit not in self.UNITS:
            return False
        else:
            return size * self.UNITS[unit]


# Test
#sysUtils = SystemUtils()
#info = sysUtils.userInfo("cristiano")
#print(sysUtils.convertSizeInBytes(" 10  MB  "))
#print(info)
#size = sysUtils.getSize("/home/cristiano/EDC/Books/")
#print(f"size: {size / (2**20)}")
#[total, used, free] = sysUtils.getFileSystemSize("/")
#print(f"total: {total}, used: {used}, free: {free}")
