#!/usr/bin/env python

class TapeTask(object):
    
    def __init__(self):
        self.inUseTapes = None
        self.inUsePools = None
        self.inUseNodeGroups = None
        self.inUseDrives = None
        self.cmdParam = None
        self.result = None
        self.status = None
        self.completedTime = None
        self.startedTime = None
        self.createdTime = None
        self.setInUseLibs = None
        self.type = None
        self.taskId = None
        self.id = None
    
    """
    Getters
    """
    
    def getResult(self):
        return self.result
      
    def getStatus(self):
        return self.status    
      
    def succeeded(self):
        return self.result == "succeeded"
      
    def failed(self):
        return self.result == "failed"
      
    def aborted(self):
        return self.result == "aborted"
      
    def canceled(self):
        return self.result == "canceled"
      
    def isCreated(self):
        return self.status == "created"
      
    def isRunning(self):
        return self.status == "running"
      
    def isWaiting(self):
        return self.status == "waiting"
      
    def isCompleted(self):
        return self.status == "completed"
    
    
    """
    Setters
    """
    
    def setInUseTapes(self, inUseTapes):
        self.inUseTapes = inUseTapes
        
    def setInUsePools(self, inUsePools):
        self.inUsePools = inUsePools
        
    def setInUseNodeGroups(self, inUseNodeGroups):
        self.inUseGroups = inUseGroups
    
    def setInUseDrives(self, inUseDrives):
        self.inUseNodeDrives = inUseDrives
        
    def setCmdParam(self, cmdParam):
        self.cmdParam = cmdParam
        
    def setResult(self, result):
        self.result = result
      
    def setStatus(self, status):
        self.status = status
    
    def setCompletedTime(self, completedTime):
        self.completedTime = completedTime
    
    def setStartedTime(self, startedTime):
        self.startedTime = startedTime
        
    def setCreatedTime(self, createdTime):
        self.createdTime = createdTime
    
    def setInUseLibs(self, inUseLibs):
        self.setInUseLibs = inUseLibs
        
    def setType(self, type):
        self.type = type
    
    def setTaskId(self, taskId):
        self.taskId = taskId
        
    def setId(self, id):
        self.id = id
