import psycopg2
try:
    conn = psycopg2.connect(user = "postgres",
                            password = "postgres",
                            host = "127.0.0.1",
                            port = "5432",
                            database = "vospace_test")

    cursor = conn.cursor()
    # Print PostgreSQL Connection properties
    print ( conn.get_dsn_parameters(),"\n")

    # Print PostgreSQL version
    cursor.execute("SELECT version();")
    record = cursor.fetchone()
    print("You are connected to - ", record,"\n")

    cursor.execute("CREATE TABLE IF NOT EXISTS vospace_table_test (id serial PRIMARY KEY, checksum varchar, filename varchar);")
    cursor.execute("INSERT INTO vospace_table_test (checksum, filename) VALUES (%s, %s)", ("1d2a66d119d6cec60a9d6ccc9d61d7e3", "Brother.txt",))
    conn.commit()

except (Exception, psycopg2.Error) as error :
    print ("Error while connecting to PostgreSQL", error)
finally:
    #closing database connection.
        if(conn):
            cursor.close()
            conn.close()
            print("PostgreSQL connection is closed")
