import json

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector


class GetJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "poll"
        config = Config("vos_ts.conf")        
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"])
        super(GetJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        if "jobId" in requestBody:
            self.dbConn.connect()
            dbResponse = self.dbConn.getJob(requestBody["jobId"])
            self.dbConn.disconnect()
            print(f"Db response: {dbResponse}")
            return dbResponse
        else:
            return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(GetJobAMQPServer, self).run() 
