import redis
import json

from job import Job


class JobCache(object):

    def __init__(self, host, port, db):
        self.host = host
        self.port = port
        self.db = db
        self.redisCli = redis.StrictRedis(host = self.host, 
                                          port = self.port, 
                                          db = self.db)

    def set(self, jobObj):
        data = { "jobId": jobObj.jobId,
                 "jobType": jobObj.type,
                 "ownerId": jobObj.ownerId,
                 "phase": jobObj.phase,
                 "quote": jobObj.quote,
                 "startTime": jobObj.startTime,
                 "endTime": jobObj.endTime,
                 "executionDuration": jobObj.executionDuration,
                 "destruction": jobObj.destruction,
                 "parameters": jobObj.parameters,
                 "results": jobObj.results,
                 "jobInfo": jobObj.jobInfo }
        self.redisCli.set(jobObj.jobId, json.dumps(data))

    def get(self, jobId):
        if self.redisCli.exists(jobId):
            jobObj = self.redisCli.get(jobId).decode("utf-8")
            return json.loads(jobObj)
        else:
            return json.loads('{ "error": "JOB_NOT_FOUND" }')