#import threading # only for testing purposes
#import time      # only for testing purposes
import json

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector
from job import Job
from job_queue import JobQueue


class StartJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "start"
        config = Config("vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"])
        self.pendingQueueRead = JobQueue("read_pending")
        super(StartJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        out = open("start_job_amqp_server_log.txt", "a")
        out.write(json.dumps(requestBody))
        out.close()
        self.job = Job()
        #self.job.setType("pullToVoSpace")
        #self.job.setInfo(requestBody)
        #self.job.setPhase("PENDING")
        self.job.setId(requestBody["jobId"])
        self.job.setType(requestBody["jobInfo"]["transfer"]["direction"])
        self.job.setPhase(requestBody["phase"])
        self.job.setInfo(requestBody["jobInfo"])
        self.job.setOwnerId(requestBody["ownerId"])
        self.dbConn.connect()
        self.dbConn.insertJob(self.job)
        dbResponse = self.dbConn.getJob(self.job.jobId)
        self.dbConn.disconnect()
        print(f"Db response: {dbResponse}")
        self.pendingQueueRead.insertJob(self.job)
        #t = threading.Thread(target = self.fake_job) # only for testing purposes
        #t.start()                                    # only for testing purposes
        return dbResponse
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(StartJobAMQPServer, self).run()

    # only for testing purposes        
    #def fake_job(self):
    #    time.sleep(10)
    #    print("fake_job: changing job state...")
    #    self.job.setPhase("EXECUTING")
    #    self.dbConn.connect()
    #    self.dbConn.insertJob(self.job)
    #    self.dbConn.disconnect()
    #    print("fake_job: state changed!")
