import os

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector


class StorageAMQPServer(AMQPServer):

    def __init__(self, host, port, queue):
        self.type = "storage"
        config = Config("vos_ts.conf")       
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"])
        self.storageType = None
        self.storageBasePath = None
        self.storageHostname = None
        super(StorageAMQPServer, self).__init__(host, port, queue)
    
    def execute_callback(self, requestBody):
        # 'requestType', 'mountPoint', 'hostname' and 'storageType' attributes are mandatory
        if "requestType" not in requestBody:
            response = { "responseType": "ERROR",
                         "errorCode": 1, 
                         "errorMsg": "Malformed request, missing parameters." }
        elif requestBody["requestType"] == "STORAGE_ADD":
            self.storageType = requestBody["storageType"]
            self.storageBasePath = requestBody["basePath"]
            self.storageHostname = requestBody["hostname"]
            
            if not os.path.exists(self.storageBasePath):
                response = { "responseType": "ERROR",
                             "errorCode": 2,
                             "errorMsg": "Base path doesn't exist."}
                return response
            self.dbConn.connect()
            result = self.dbConn.insertStorage(self.storageType, 
                                               self.storageBasePath, 
                                               self.storageHostname)
            self.dbConn.disconnect()

            if result:
                response = { "responseType": "STORAGE_ADD_DONE" }
                return response
            else:
                response = { "responseType": "ERROR",
                             "errorCode": 3,
                             "errorMsg": "Storage point already exists." }
                return response
        elif requestBody["requestType"] == "STORAGE_RMV":
            pass
        elif requestBody["requestType"] == "STORAGE_LST":            
            self.dbConn.connect()
            result = self.dbConn.getStorageList()
            self.dbConn.disconnect()
            
            response = { "responseType": "STORAGE_LST_DONE",
                         "storageList": result }
            
            return response
    
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(StorageAMQPServer, self).run()
