import sys

from redis_rpc_client import RedisRPCClient
from config import Config
from tabulate import tabulate


class TestDoiRPCClient(RedisRPCClient):

    def __init__(self):
        config = Config("/etc/vos_cli/vos_cli.conf")
        params = config.loadSection("server")
        self.host = params["host"]
        self.port = params.getint("port")
        self.db = params.getint("db")
        params = config.loadSection("test_doi")
        self.rpcQueue = params["rpc_queue"]
        super(TestDoiRPCClient, self).__init__(self.host, self.port, self.db, self.rpcQueue)

    def test_request(self):
        request = {
          "req_id": "5e6ff54d096246438d483c90c81512f9",
          "job": {
            "jobId": "5e6ff54d096246438d483c90c81512f9",
            "runId": None,
            "ownerId": "3354",
            "phase": "QUEUED",
            "quote": None,
            "creationTime": None,
            "startTime": None,
            "endTime": None,
            "executionDuration": 0,
            "destruction": None,
            "parameters": None,
            "results": [],
            "errorSummary": None,
            "jobInfo": {
              "transfer": {
                "target": "vos://example.com!vospace/cristiano.urban/mydir",
                "direction": "pullToVoSpace",
                "view": {
                  "param": [],
                  "uri": "ivo://ia2.inaf.it/vospace/views#async-recall",
                  "original": True
                },
                "protocols": [],
                "keepBytes": False,
                "version": None,
                "param": []
              }
            },
            "version": None
          }
        }
        response = self.call(request)

t = TestDoiRPCClient()
r = t.test_request()
