import json
import redis
import threading


class RedisRpcServer(threading.Thread):

    def __init__(self, redisUrl, listName):
        threading.Thread.__init__(self)
        self.client = redis.from_url(redisUrl)
        self.listName = listName

    def run(self):
        print("Starting RPC server for " + self.listName)
        while True:
            channel, request = self.client.brpop(self.listName)
            channel = channel.decode("utf-8")
            request = json.loads(request.decode("utf-8"))

            print(channel)
            print(request)

            result = 42

            reply = {
              "jsonrpc": "2.0",
              "result": result,
              "id": request["id"]
            }

            self.client.rpush(request["id"], json.dumps(reply))
            self.client.expire(request["id"], 30)


server = RedisRpcServer("redis://job_cache:6379", "testList")
server.start()
