#!/usr/bin/env python

class Error(Exception):
    """Base class for exceptions."""
    pass 


# FileGrouper exceptions

class TarFileCreationException(Error):
    def __init__(self, folder):
        self.message = "Error: cannot create a .tar for " + folder
        super(TarFileCreationException, self).__init__(self.message)


# RapClient exceptions

class MultipleUsersException(Error):
    def __init__(self):
        self.message = "Multiple users found with the same email address."
        super(MultipleUsersException, self).__init__(self.message)


# TapeClient exceptions

class TapeClientException(Error):
    def __init__(self, cmd, exitCode, errorMsg):
        self.message = f"{cmd}\nexitCode: {exitCode}\nerrorMsg: {errorMsg}\n"
        super(TapeClientException, self).__init__(self.message)
        
class ScpInvalidFileException(Error):
    def __init__(self):
        self.message = "Error: invalid file or directory."
        super(ScpInvalidFileException, self).__init__(self.message)
