import json
import redis
import threading
import time

from redis.exceptions import ConnectionError


class RedisRPCServer(threading.Thread):

    def __init__(self, host, port, db, rpcQueue):
        threading.Thread.__init__(self)
        self.redisUrl = "redis://" + host + ':' + str(port) + '/' + str(db)
        self.client = redis.from_url(self.redisUrl)
        self.rpcQueue = rpcQueue

    def run(self):
        while True:
            try:
                # block the connection if the there is nothing to pop
                channel, request = self.client.brpop(self.rpcQueue)                
            except ConnectionError:
                time.sleep(2)
            except Exception:
                raise
            else:
                channel = channel.decode("utf-8")
                request = json.loads(request.decode("utf-8"))
                response = self.callback(request)
                self.client.rpush(request["req_id"], json.dumps(response))
                self.client.expire(request["req_id"], 30)

    def callback(self, request):
        """
        This method must be implemented by
        inherited classes
        """
        pass
