#!/usr/bin/env python

import json
import logging

from redis_log_handler import RedisLogHandler
from redis_rpc_server import RedisRPCServer
from config import Config
from db_connector import DbConnector


class GetJobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "poll"
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(params["user"],
                                  params["password"],
                                  params["host"],
                                  params.getint("port"),
                                  params["db"],
                                  1,
                                  2)
        params = config.loadSection("logging")
        self.logger = logging.getLogger(__name__)
        logLevel = "logging." + params["log_level"]
        logFormat = params["log_format"]
        logFormatter = logging.Formatter(logFormat)
        self.logger.setLevel(eval(logLevel))
        redisLogHandler = RedisLogHandler()
        logStreamHandler = logging.StreamHandler()
        logStreamHandler.setFormatter(logFormatter)
        redisLogHandler.setFormatter(logFormatter)
        self.logger.addHandler(redisLogHandler)
        self.logger.addHandler(logStreamHandler)
        super(GetJobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        if "jobId" in requestBody:
            dbResponse = self.dbConn.getJob(requestBody["jobId"])
            print(f"Db response: {dbResponse}")
            return dbResponse
        else:
            #TODO
            return 42

    def run(self):
        self.logger.info(f"Starting RPC server of type {self.type}...")
        super(GetJobRPCServer, self).run()
