#!/usr/bin/env python

import os
import redis
import time

from multiprocessing import Process

from config import Config


class LogListener(Process):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("job_cache")
        self.redisCli = redis.Redis(host = params["host"],
                                    port = params["port"],
                                    db = params["db_sched"])
        params = config.loadSection("logging")
        logDir = params["log_dir"]
        logFile = params["log_file"]
        self.logQueue = params["log_queue"]
        self.logFilePath = os.path.join(logDir, logFile)
        super(LogListener, self).__init__()

    def run(self):
        if os.path.exists(self.logFilePath):
            os.remove(self.logFilePath)
        while True:
            time.sleep(1)
            while self.redisCli.llen(self.logQueue) > 0:
                lfp = open(self.logFilePath, 'a')
                logRecord = self.redisCli.brpop(self.logQueue)[1].decode("utf-8")
                lfp.write(logRecord + '\n')
                lfp.close()
