#!/usr/bin/env python

import redis
import logging

from config import Config


class RedisLogHandler(object):
    """
    Log handler for sending log records to a Redis queue.
    """
    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("job_cache")
        self.redisCli = redis.Redis(host = params["host"],
                                    port = params["port"],
                                    db = params["db_sched"])
        params = config.loadSection("logging")
        self.logQueue = params["log_queue"]
        logLevel = "logging." + params["log_level"]
        self.level = eval(logLevel)
        self.formatter = logging.Formatter()

    def handle(self, record):
        try:
            self.redisCli.lpush(self.logQueue, self.formatter.format(record))
        except:
            # Redis is not responding...
            pass

    def setFormatter(self, formatter):
        self.formatter = formatter
