#!/usr/bin/env python

import json
import logging
import os

from config import Config
from db_connector import DbConnector
from redis_log_handler import RedisLogHandler
from task_executor import TaskExecutor


class RetrievePreprocessor(TaskExecutor):

    def __init__(self):
        self.type = "retrieve_preprocessor"
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(params["user"],
                                  params["password"],
                                  params["host"],
                                  params.getint("port"),
                                  params["db"],
                                  1,
                                  1)
        params = config.loadSection("logging")
        self.logger = logging.getLogger(__name__)
        logLevel = "logging." + params["log_level"]
        logFormat = params["log_format"]
        logFormatter = logging.Formatter(logFormat)
        self.logger.setLevel(eval(logLevel))
        redisLogHandler = RedisLogHandler()
        logStreamHandler = logging.StreamHandler()
        logStreamHandler.setFormatter(logFormatter)
        redisLogHandler.setFormatter(logFormatter)
        self.logger.addHandler(redisLogHandler)
        self.logger.addHandler(logStreamHandler)
        self.jobObj = None
        self.nodeList = []
        super(RetrievePreprocessor, self).__init__()

    def execute(self):
        vospacePathList = self.jobObj.jobInfo["transfer"]["target"]
        for vospacePath in vospacePathList:
            self.nodeList.append(vospacePath.split("!vospace")[1])
        self.jobObj.jobInfo["nodeList"] = self.nodeList.copy()

    def cleanup(self):
        self.nodeList.clear()

    def run(self):
        self.logger.info("Starting retrieve preprocessor...")
        self.setSourceQueueName("read_pending")
        self.setDestinationQueueName("read_ready")
        while True:
            self.wait()
            if self.destQueue.len() < self.maxReadyJobs and self.srcQueue.len() > 0:
                self.jobObj = self.srcQueue.getJob()
                self.execute()
                self.destQueue.insertJob(self.jobObj)
                self.srcQueue.extractJob()
                self.cleanup()
                self.logger.info(f"Job {self.jobObj.jobId} MOVED from {self.srcQueue.name()} to {self.destQueue.name()}")
