#!/usr/bin/env python

import sys

from data_rpc_server import DataRPCServer
from import_rpc_server import ImportRPCServer
from job_rpc_server import JobRPCServer
from storage_rpc_server import StorageRPCServer


class CliHandler(object):

    def __init__(self, host, port, db):
        self.host = host
        self.port = port
        self.db = db
        self.rpcServerList = []

    def addRPCServer(self, srvType, rpcQueue):
        if srvType == 'data':
            self.rpcServerList.append(DataRPCServer(self.host, self.port, self.db, rpcQueue))
        elif srvType == 'import':
            self.rpcServerList.append(ImportRPCServer(self.host, self.port, self.db, rpcQueue))
        elif srvType == 'storage':
            self.rpcServerList.append(StorageRPCServer(self.host, self.port, self.db, rpcQueue))
        elif srvType == 'job':
            self.rpcServerList.append(JobRPCServer(self.host, self.port, self.db, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")

    def start(self):
        for srv in self.rpcServerList:
            srv.start()
