#!/usr/bin/env python

from configparser import ConfigParser, ExtendedInterpolation


class Config(object):

    def __init__(self, fileName):
        self.fileName = fileName
        self.config = ConfigParser(interpolation = ExtendedInterpolation())
        self.config.read(fileName)        

    def loadSection(self, sectionName):
        section = self.config[sectionName]
        return section

# Test
#c = Config("vos_ts.conf")
#params = c.loadSection("file_grouper")
#print(params.getint("min_num_files"))
#print(eval(params["max_dir_size"]))
