#!/usr/bin/env python

import json

from redis_rpc_server import RedisRPCServer
from config import Config
from db_connector import DbConnector


class GetJobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "poll"
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"],
                                  self.params["password"],
                                  self.params["host"],
                                  self.params.getint("port"),
                                  self.params["db"],
                                  1,
                                  2)
        super(GetJobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        if "jobId" in requestBody:
            dbResponse = self.dbConn.getJob(requestBody["jobId"])
            print(f"Db response: {dbResponse}")
            return dbResponse
        else:
            #TODO
            return 42

    def run(self):
        print(f"Starting RPC server of type {self.type}...")
        super(GetJobRPCServer, self).run()
