import pika
import sys

from import_amqp_server import ImportAMQPServer
from job_amqp_server import JobAMQPServer
from start_job_amqp_server import StartJobAMQPServer
from storage_amqp_server import StorageAMQPServer
from get_job_amqp_server import GetJobAMQPServer
from abort_job_amqp_server import AbortJobAMQPServer
from store_amqp_server import StoreAMQPServer


class JobHandler(object):

    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.amqpServerList = []

    def addAMQPServer(self, srvType, rpcQueue):
        if srvType == 'start':
            self.amqpServerList.append(StartJobAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'poll':
            self.amqpServerList.append(GetJobAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'abort':
            self.amqpServerList.append(AbortJobAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'store':
            self.amqpServerList.append(StoreAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'import':
            self.amqpServerList.append(ImportAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'storage':
            self.amqpServerList.append(StorageAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'job':
            self.amqpServerList.append(JobAMQPServer(self.host, self.port, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")

    def start(self):
        for srv in self.amqpServerList:
            srv.start()
