#!/usr/bin/env python

from amqp_server import AMQPServer
from db_connector import DbConnector
from config import Config


class AbortJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "abort"
        config = Config("/etc/vos_ts/vos_ts.conf")        
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"],
                                  8,
                                  16)
        super(AbortJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        #TODO
        # do something...
        return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(AbortJobAMQPServer, self).run() 
