#!/usr/bin/env python

import datetime
import os

from config import Config
from db_connector import DbConnector


config = Config("/etc/vos_ts/vos_ts.conf")
params = config.loadSection("file_catalog")
dbConn = DbConnector(params["user"],
                     params["password"],
                     params["host"],
                     params.getint("port"),
                     params["db"],
                     1,
                     1)
params = config.loadSection("cleanup")
days = params.getint("days")
seconds = params.getint("hours") * 3600 + params.getint("minutes") * 60 + params.getint("seconds")

# Avoid "all zero" condition
if days <= 0 and seconds < 30:
    days = 0
    seconds = 30
elif seconds >= 86400:
    days += seconds // 86400
    seconds = seconds % 86400

fileList = dbConn.getNodesToBeDeleted()
basePaths = []
for row in fileList:
    basePath = row["os_base_path"]
    relPath = row["os_rel_path"]
    filePath = basePath + relPath
    dTime = row["deleted_on"]
    cTime = datetime.datetime.now()
    phyDeletedTstamp = row["phy_deleted_on"]
    nodeId = row["node_id"]
    delta = cTime - dTime
    if delta.days >= days and delta.seconds > seconds and phyDeletedTstamp is None:
        os.remove(filePath)
        print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + ' ' + filePath)
        dbConn.setPhyDeletedOn(nodeId)
        if basePath not in basePaths:
            basePaths.append(basePath)

for basePath in basePaths:
    for root, dirs, files in os.walk(basePath, topdown = False):
        for dir in dirs:
            dirPath = os.path.abspath(root) + '/' + dir
            if not os.listdir(dirPath):
                os.rmdir(dirPath)
                print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + ' ' + dirPath)

# 1) delete files and update the db
# 2) check for empty dirs and delete them if different from rootPath
