#!/usr/bin/env python 

import sys

from data_amqp_server import DataAMQPServer
from import_amqp_server import ImportAMQPServer
from job_amqp_server import JobAMQPServer
from storage_amqp_server import StorageAMQPServer


class CliHandler(object):

    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.amqpServerList = []

    def addAMQPServer(self, srvType, rpcQueue):
        if srvType == 'data':
            self.amqpServerList.append(DataAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'import':
            self.amqpServerList.append(ImportAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'storage':
            self.amqpServerList.append(StorageAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'job':
            self.amqpServerList.append(JobAMQPServer(self.host, self.port, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")
            
    def start(self):
        for srv in self.amqpServerList:
            srv.start()
