#!/usr/bin/env python

import json

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector


class GetJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "poll"
        config = Config("/etc/vos_ts/vos_ts.conf")        
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"],
                                  8,
                                  16)
        super(GetJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        if "jobId" in requestBody:
            dbResponse = self.dbConn.getJob(requestBody["jobId"])
            print(f"Db response: {dbResponse}")
            return dbResponse
        else:
            #TODO
            return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(GetJobAMQPServer, self).run() 
