#!/usr/bin/env python

from retrieve_preprocessor import RetrievePreprocessor
from store_preprocessor import StorePreprocessor
from retrieve_executor import RetrieveExecutor
from store_executor import StoreExecutor



class JobScheduler(object):

    def __init__(self):
        self.retrievePreprocessor = RetrievePreprocessor()
        self.storePreprocessor = StorePreprocessor()
        self.retrieveExecutor = RetrieveExecutor()
        self.storeExecutor = StoreExecutor()

    def start(self):
        self.retrievePreprocessor.start()
        self.storePreprocessor.start()
        self.retrieveExecutor.start()
        self.storeExecutor.start()
