#!/usr/bin/env python

import json

from amqp_server import AMQPServer
from config import Config
from db_connector import DbConnector
from job import Job
from job_queue import JobQueue


class StartJobAMQPServer(AMQPServer):
  
    def __init__(self, host, port, queue):
        self.type = "start"
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"], 
                                  self.params["password"], 
                                  self.params["host"], 
                                  self.params.getint("port"), 
                                  self.params["db"],
                                  8,
                                  16)
        self.pendingQueueRead = JobQueue("read_pending")
        super(StartJobAMQPServer, self).__init__(host, port, queue)      

    def execute_callback(self, requestBody):
        out = open("start_job_amqp_server_log.txt", "a")
        out.write(json.dumps(requestBody))
        out.close()
        job = Job()
        job.setId(requestBody["jobId"])
        job.setType(requestBody["jobInfo"]["transfer"]["direction"])
        job.setPhase(requestBody["phase"])
        job.setInfo(requestBody["jobInfo"])
        job.setOwnerId(requestBody["ownerId"])
        self.dbConn.insertJob(job)
        dbResponse = self.dbConn.getJob(job.jobId)
        print(f"Db response: {dbResponse}")
        self.pendingQueueRead.insertJob(job)
        return dbResponse
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(StartJobAMQPServer, self).run()
