#!/usr/bin/env python

from config import Config
from cli_handler import CliHandler
from job_scheduler import JobScheduler
from vospace_rest_handler import VOSpaceRestHandler


class TransferService(object):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("amqp")
        self.cliHandler = CliHandler(self.params["host"], self.params.getint("port"))
        self.vosRestHandler = VOSpaceRestHandler(self.params["host"], self.params.getint("port"))
        self.jobScheduler = JobScheduler()

        # PullToVOSpace (via REST API)
        self.vosRestHandler.addAMQPServer('start', 'start_job_queue')
        self.vosRestHandler.addAMQPServer('poll', 'poll_job_queue')
        self.vosRestHandler.addAMQPServer('abort', 'abort_job_queue')

        # PushToVOSpace (via vos_data, the 'unofficial' command line client)
        self.cliHandler.addAMQPServer('data', 'data_queue')       
        
        # Import
        self.cliHandler.addAMQPServer('import', 'import_queue')
        
        # Job
        self.cliHandler.addAMQPServer('job', 'job_queue')
        
        # Storage
        self.cliHandler.addAMQPServer('storage', 'storage_queue')
        
        # Startup
        self.jobScheduler.start()
        self.vosRestHandler.start()
        self.cliHandler.start()

    def start(self):
        print("\nTransfer service is RUNNING...\n")
        

ts = TransferService()
ts.start()
