#!/usr/bin/env python

#import pika
import sys

from start_job_amqp_server import StartJobAMQPServer
from get_job_amqp_server import GetJobAMQPServer
from abort_job_amqp_server import AbortJobAMQPServer


class VOSpaceRestHandler(object):

    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.amqpServerList = []

    def addAMQPServer(self, srvType, rpcQueue):
        if srvType == 'start':
            self.amqpServerList.append(StartJobAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'poll':
            self.amqpServerList.append(GetJobAMQPServer(self.host, self.port, rpcQueue))
        elif srvType == 'abort':
            self.amqpServerList.append(AbortJobAMQPServer(self.host, self.port, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")

    def start(self):
        for srv in self.amqpServerList:
            srv.start()
