import pika
import uuid
import json
import sys


class AMQPClient(object):

    def __init__(self, rpcQueue):
        self.rpcQueue = rpcQueue
        self.connection = pika.BlockingConnection(pika.ConnectionParameters(host = 'rabbitmq'))
        self.channel = self.connection.channel()
        result = self.channel.queue_declare(queue = '', exclusive = True)
        self.callback_queue = result.method.queue
        self.channel.basic_consume(queue = self.callback_queue, on_message_callback = self.on_response, auto_ack = True)

    def on_response(self, ch, method, props, body):
        if self.corr_id == props.correlation_id:
            self.response = json.loads(body)

    def call(self, msg):
        self.response = None
        self.corr_id = str(uuid.uuid4())
        self.channel.basic_publish(exchange = '',
                                   routing_key = self.rpcQueue,
                                   properties = pika.BasicProperties(reply_to = self.callback_queue,
                                                                     correlation_id = self.corr_id,
                                                                    ),
                                   body = json.dumps(msg))

        while self.response is None:
            self.connection.process_data_events()
        return self.response
      

if len(sys.argv) == 2:
    script, queue = sys.argv
elif len(sys.argv) == 3:
    script, queue, jobid = sys.argv
else:
    sys.exit("FATAL: wrong number of input args.")

if queue == 'start_job_queue':
    testClient = AMQPClient(queue)
    transferRequest = { "transfer":
                         {
                            "@version": "2.1",
                            "target": "vos://example.com!vospace/mydata1",
                            "direction": "pullFromVoSpace",
                            "protocol": {
                               "@uri": "ivo://ivoa.net/vospace/core#httpget"
                            }
                         }
                      }
    print("Sending transfer request:")
    print(json.dumps(transferRequest, indent = 3))
    response = testClient.call(transferRequest)
    print("Response:")
    print(json.dumps(response, indent = 3))
elif queue == 'poll_job_queue':
    testClient = AMQPClient(queue)
    pollRequest = { "jobId": jobid }
    print("Sending poll request:")
    print(json.dumps(pollRequest, indent = 3))
    response = testClient.call(pollRequest)
    print("Response:")
    print(json.dumps(response, indent = 3))
else:
    sys.exit("FATAL: invalid queue name.")
