/**_____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 2020  Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 **/

/*
    VOSpace front-end
*/

CREATE EXTENSION IF NOT EXISTS ltree;

CREATE TYPE NodeType AS ENUM ('container', 'data', 'link');

CREATE TABLE Node (
    nodeID           BIGSERIAL     NOT NULL,
    path             LTREE         default NULL,
    name             VARCHAR       NOT NULL,
    type             NodeType      NOT NULL,
    format           VARCHAR       default NULL,
    -- format serve per distinguere unstuctured (format=NULL) da structured che hanno un formato noto
    asyncTrans       BOOLEAN       NOT NULL,
    -- asyncTransf serve per indicare se il nodo e` ospitato da un cold storage e deve essere necessariamente 
    -- trasferito con un trasferimento asincrono 
    busyState        BOOLEAN       NOT NULL,
    ownerID          VARCHAR       NOT NULL,
    creatorID        VARCHAR       NOT NULL,
    groupRead        VARCHAR[]     default NULL,
    groupWrite       VARCHAR[]     default NULL,
    isPublic         BOOLEAN       NOT NULL,
    delta            BIGINT        default NULL,
    /* potrebbe essere un delta di dati trasferito durante un trasferimento asincrono.
       Dovrebbe stare sul servizio che fa il trasferimento  (es. redis) */
    contentType      VARCHAR       default NULL,
    contentEncoding  VARCHAR       default NULL,
    contentLength    BIGINT        default NULL,
    contentMD5       TEXT          default NULL,
    createdOn        TIMESTAMP     default CURRENT_TIMESTAMP,
    lastModified     TIMESTAMP     NOT NULL,
    -- link             TEXT          default NULL,
    acceptViews      TEXT[]        default NULL,
    provideViews     TEXT[]        default NULL,
    -- serve per mappare il nome del servizio di storage da interrogare per accedere al contenuto di questo nodo 
    -- storageID        VARCHAR,    
    protocols        TEXT[]        default NULL,
    PRIMARY KEY (nodeID)
);


CREATE TABLE NodeProperty (
    nodeID           BIGSERIAL,
    propertyURI      VARCHAR       NOT NULL,
    propertyValue    VARCHAR       default NULL,
    lastModified     TIMESTAMP     default CURRENT_TIMESTAMP,
    -- support replication with a fake primary key
    -- _rep_support     BIGINT       NOT NULL PRIMARY KEY,
    foreign key (nodeID) references Node (nodeID)
);


CREATE TABLE DeletedNode (
    nodeID           BIGSERIAL     NOT NULL,
    name             VARCHAR       NOT NULL,
    ownerID          VARCHAR       NOT NULL,
    lastModified     TIMESTAMP     default CURRENT_TIMESTAMP,
    PRIMARY KEY (nodeID)
);


/*
   Initialize root node for vospace
*/

INSERT INTO Node (name, type, asyncTrans, busyState, ownerID, creatorID, groupRead, groupWrite, isPublic, lastModified) VALUES ('YOUR_ROOT_NODE', 'container', '1', 'N', '9127391732918723981732198273275643832902', '9127391732918723981732198273275643832902', '{"YOUR_ADMIN_GROUP"}', '{"YOUR_ADMIN_GROUP"}', '1', CURRENT_TIMESTAMP);
