import hashlib
import sys
import os

script, dir = sys.argv

def md5sum(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()

for folder, subfolder, files in os.walk(dir, topdown = False):
    #print(folder, os.path.basename(folder), subfolder, files)
    cwd = os.path.basename(folder)
    parent = os.path.dirname(folder)
    #parent = os.path.basename(parent)
    #print(cwd, parent, os.path.abspath(parent))
    #print(os.path.abspath(folder))
    if not os.path.exists(os.path.abspath(parent) + '/' + cwd +  "-md5sum.txt"):
        #if not os.listdir(folder) == []:
        if not files == []:
            md5file = open(os.path.abspath(parent) + '/' + cwd + "-md5sum.txt", 'w')
            for file in files:
                #print(file)
                md5file.write(md5sum(os.path.abspath(folder) + '/' + file) + "  ./" + file)
                md5file.write('\n')
            md5file.close()
