from amqp_server import AMQPServer
from job_cache import JobCache

class AbortJobAMQPServer(AMQPServer):
  
    def __init__(self, host, queue):
        self.type = "abort"
        self.jobCache = JobCache('redis', 6379, 0)
        super(AbortJobAMQPServer, self).__init__(host, queue)      

    def execute_callback(self, requestBody):
        return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(AbortJobAMQPServer, self).run() 
