import hashlib
import os
import sys


class Checksum(object):

    def __init__(self):
        self.fileBufferSize = 4096
        self.md5FileSuffix = "-md5sum.txt"

    def setFileBufferSize(fileBufferSize):
        self.fileBufferSize = fileBufferSize

    def md5sum(self, filePath):
        md5Hash = hashlib.md5()
        with open(filePath, "rb") as f:
            for chunk in iter(lambda: f.read(self.fileBufferSize), b""):
                md5Hash.update(chunk)
        return md5Hash.hexdigest()

    def recursive(self, folderPath):
        for folder, subfolder, files in os.walk(folderPath, topdown = False):
            cwd = os.path.basename(folder)
            parent = os.path.dirname(folder)
            md5FilePath = os.path.abspath(parent) + '/' + cwd + self.md5FileSuffix
            if not os.path.exists(md5FilePath):
                if not files == []:
                    md5file = open(md5FilePath, 'w')
                    for file in files:
                        filePath = os.path.abspath(folder) + '/' + file
                        md5file.write(self.md5sum(filePath) + "  ./" + file + '\n')
                    md5file.close()
