import os
import shutil
import sys
import subprocess


class FileGrouper(object):
    # Constructor requiring the minimum number of files
    # and the maximum folder size in bytes (constraints)
    def __init__(self, minNumOfFiles, maxFolderSize):
        self.minNumOfFiles = minNumOfFiles
        self.maxFolderSize = maxFolderSize

    # Sets the 'minimum number of files' constraint
    def setMinNumOfFiles(self, minNumOfFiles):
        self.minNumOfFiles = minNumOfFiles
      
    # Sets the 'maximum folder size' constraint  
    def setMaxFolderSize(self, maxFolderSize):
        self.maxFolderSize = maxFolderSize

    # Returns a list of all the 'leaves' (directories not
    # containing subdirectories) within the path
    def getLeaves(self):
        leaves = []
        for root, dirs, files in os.walk(self.folderPath):
            if not dirs:
                leaves.append(root)
        return leaves

    # Returns the folder size in bytes
    def getFolderSize(self, folder):
        files = []
        for f in os.listdir(folder):
            files.append(os.path.abspath(folder) + '/' + f)  
        folderSize = 0
        for f in files:
            statinfo = os.stat(f)
            folderSize += statinfo.st_size           
        return folderSize

    # Returns the number of files contained into a folder
    def getNumOfFiles(self, folder):
        return len(os.listdir(folder))

    # Start the .tar creation procedure
    def recursive(self, folderPath):
        self.folderPath = folderPath
        leaves = self.getLeaves()
        for folder in leaves:
            if(self.getNumOfFiles(folder) > self.minNumOfFiles and self.getFolderSize(folder) < self.maxFolderSize):
                cwd = os.getcwd()
                parent = os.path.dirname(folder)
                os.chdir(parent)
                sp = subprocess.run(["tar", "-cf", os.path.basename(folder) + ".tar", os.path.basename(folder)], capture_output = True)
                if(sp.returncode or sp.stderr):
                    sys.exit(f"Error: cannot create a .tar for {folder}")
                else:
                    try:
                        shutil.rmtree(folder)
                    except OSError as e:
                        sys.exit(f"Error: {folder} => {e.strerror}")
                os.chdir(cwd)


# Test (creates a .tar of all the leaves containing at least 2 files and having size lower than 100G,
# than removes those directories)
fg = FileGrouper(1, 100 * (2 ** 30))
fg.recursive("/home/cristiano/Lavoro/md5_test/store/a")
