from amqp_server import AMQPServer
from job_cache import JobCache

class GetJobAMQPServer(AMQPServer):
  
    def __init__(self, host, queue):
        self.type = "poll"
        self.jobCache = JobCache('redis', 6379, 0)
        super(GetJobAMQPServer, self).__init__(host, queue)      

    def execute_callback(self, requestBody):
        if "jobId" in requestBody:
            redis_res = self.jobCache.get(requestBody["jobId"])
            print(f"Redis response: {redis_res}")
            return redis_res
        else:
            return 42
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(GetJobAMQPServer, self).run() 
