import pika
import sys

from start_job_amqp_server import StartJobAMQPServer
from get_job_amqp_server import GetJobAMQPServer
from abort_job_amqp_server import AbortJobAMQPServer
from store_amqp_server import StoreAMQPServer

class JobHandler(object):

    def __init__(self, host):
        self.host = host
        self.amqpServerList = []

    def addAMQPServer(self, srvType, rpcQueue):
        if srvType == 'start':
            self.amqpServerList.append(StartJobAMQPServer(self.host, rpcQueue))
        elif srvType == 'poll':
            self.amqpServerList.append(GetJobAMQPServer(self.host, rpcQueue))
        elif srvType == 'abort':
            self.amqpServerList.append(AbortJobAMQPServer(self.host, rpcQueue))
        elif srvType == 'store':
            self.amqpServerList.append(StoreAMQPServer(self.host, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")

    def run(self):
        for srv in self.amqpServerList:
            srv.start()
