import threading # only for testing purposes
import time      # only for testing purposes

from amqp_server import AMQPServer
from job import Job
from job_cache import JobCache


class StartJobAMQPServer(AMQPServer):
  
    def __init__(self, host, queue):
        self.type = "start"
        self.jobCache = JobCache('redis', 6379, 0)
        super(StartJobAMQPServer, self).__init__(host, queue)      

    def execute_callback(self, requestBody):
        self.job = Job()
        self.job.setInfo(requestBody)
        self.job.setPhase("PENDING")
        self.jobCache.set(self.job)
        redis_res = self.jobCache.get(self.job.jobId)
        print(f"Redis response: {redis_res}")
        t = threading.Thread(target = self.fake_job) # only for testing purposes
        t.start()                                    # only for testing purposes
        return redis_res            
      
    def run(self):
        print(f"Starting AMQP server of type {self.type}...")
        super(StartJobAMQPServer, self).run()

    # only for testing purposes        
    def fake_job(self):
        time.sleep(10)
        print("fake_job: changing job state...")
        self.job.setPhase("EXECUTING")
        self.jobCache.set(self.job)
        print("fake_job: state changed!")