# TODO:
# - interface with the file catalog (insert)
# - data and permissions cleanup
#

import os
import shutil
import sys

from datetime import datetime as dt
from checksum import Checksum
from file_grouper import FileGrouper


class StorePreprocessor(object):

    def __init__(self):
        self.md5calc = Checksum()
        self.fileGrouper = FileGrouper(1000, 100 * (2 ** 30))

    def scan(self):
        dirList = []
        fileList = []
        elementList = os.listdir(self.path)
        for el in elementList:
            elPath = self.path + '/' + el
            if os.path.isdir(elPath):
                dirList.append(el)
            elif os.path.isfile(elPath):
                fileList.append(el)
            else:
                sys.exit("FATAL: invalid file/dir.")
        return [ dirList, fileList ]

    def prepare(self, username):
        self.username = username
        self.path = "/home/" + username + "/store"
        for folder, subfolders, files in os.walk(self.path):
            os.chown(folder, 0, 0)
            os.chmod(folder, 0o555)
            for s in subfolders:
                os.chown(os.path.join(folder, s), 0, 0)
                os.chmod(os.path.join(folder, s), 0o555)
            for f in files:
                os.chown(os.path.join(folder, f), 0, 0)
                os.chmod(os.path.join(folder, f), 0o555)

    def start(self):
        # First scan
        [ dirs, files ] = self.scan()        
        
        # Create a .tar for all dirs matching the constraints, if any
        for dir in dirs:
            self.fileGrouper.recursive(self.path + '/' + dir)
        
        # Second scan
        [ dirs, files ] = self.scan()
        timestamp = dt.now().strftime("%Y_%m_%d-%H_%M_%S")
        
        # Case 1: /home/user/store contains both files and dirs
        if files and dirs:
            destPath = self.path + '/' + timestamp
            try:
                os.mkdir(destPath)
            except OSError as error:
                sys.exit(f"FATAL: {error}")
            for file in files:
                srcPath = self.path + '/' + file
                shutil.move(srcPath, destPath)
            for dir in dirs:
                srcPath = self.path + '/' + dir                
                shutil.move(srcPath, destPath)
            self.md5calc.recursive(destPath)
        # Case 2: /home/user/store contains only files    
        elif files and not dirs:
            destPath = self.path + '/' + timestamp
            try:
                os.mkdir(destPath)
            except OSError as error:
                sys.exit(f"FATAL: {error}")
            for file in files:
                srcPath = self.path + '/' + file
                shutil.move(srcPath, destPath)
            self.md5calc.recursive(destPath)
        # Case 3: /home/user/store contains only dirs
        elif not files and dirs:
            for dir in dirs:
                destPath = self.path + '/' + dir
                self.md5calc.recursive(destPath)
        # Case 4: /home/user/store is empty
        else:
            sys.exit("The 'store' directory is empty.")

# Test
sp = StorePreprocessor()
sp.prepare("cristiano")
sp.start()