import time
import os

from XRootD import client
from job_handler import JobHandler


class TransferService(object):

    def __init__(self):
        self.jobHandler = JobHandler('rabbitmq')

        # PullFromVOSpace
        self.jobHandler.addAMQPServer('start', 'start_job_queue')
        self.jobHandler.addAMQPServer('poll', 'poll_job_queue')
        self.jobHandler.addAMQPServer('abort', 'abort_job_queue')

        # Push
        self.jobHandler.addAMQPServer('store', 'store_job_queue')

    def run(self):
        self.jobHandler.run()

ts = TransferService()
ts.run()
print("Transfer service is RUNNING...")

time.sleep(10)
print("Starting XRootD transfer test [remote-to-remote]...")
process = client.CopyProcess()
process.add_job(source = 'root://tape_frontend//home/tape_frontend/data/aaa/1.txt',
                target = 'root://transfer_node//home/transfer_node/data/aaa/1.txt',
                mkdir = True,
                force = True )
process.add_job(source = 'root://tape_frontend//home/tape_frontend/data/aaa/3.txt',
                target = 'root://transfer_node//home/transfer_node/data/aaa/3.txt',
                mkdir = True,
                force = True )
process.prepare()
process.run()
#time.sleep(3)
#os.system('du -a /home/centos')
