#!/usr/bin/env python

from redis_rpc_server import RedisRPCServer
from db_connector import DbConnector
from config import Config


class AbortJobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "abort"
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"],
                                  self.params["password"],
                                  self.params["host"],
                                  self.params.getint("port"),
                                  self.params["db"],
                                  8,
                                  16)
        super(AbortJobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        #TODO
        # do something...
        return 42

    def run(self):
        print(f"Starting RPC server of type {self.type}...")
        super(AbortJobRPCServer, self).run()
