#!/usr/bin/env python

import os

from redis_rpc_server import RedisRPCServer
from config import Config
from db_connector import DbConnector


class JobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "job"
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"],
                                  self.params["password"],
                                  self.params["host"],
                                  self.params.getint("port"),
                                  self.params["db"],
                                  8,
                                  16)
        super(JobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        # 'requestType' attribute is mandatory
        if "requestType" not in requestBody:
            response = { "responseType": "ERROR",
                         "errorCode": 1,
                         "errorMsg": "Malformed request, missing parameters." }
        elif requestBody["requestType"] == "JOB_LIST":
            result = self.dbConn.listActiveJobs()
            response = { "responseType": "LST_DONE", "jobList": result }
        elif requestBody["requestType"] == "JOB_BY_PHASE":
            jobPhase = requestBody["jobPhase"]
            result = self.dbConn.listJobsByPhase(jobPhase)
            response = { "responseType": "LST_BY_PHASE_DONE", "jobList": result }
        elif requestBody["requestType"] == "JOB_INFO":
            jobId = requestBody["jobId"]
            if self.dbConn.jobExists(jobId):
                result = self.dbConn.getJobInfo(jobId)
                response = { "responseType": "LST_INFO_DONE", "jobInfo": result }
            else:
                response = { "responseType": "ERROR",
                             "errorCode": 2,
                             "errorMsg": "Wrong job ID." }
        elif requestBody["requestType"] == "JOB_RESULTS":
            jobId = requestBody["jobId"]
            if self.dbConn.jobExists(jobId):
                result = self.dbConn.getJobResults(jobId)
                response = { "responseType": "LST_RESULTS_DONE", "jobResults": result }
            else:
                response = { "responseType": "ERROR",
                             "errorCode": 2,
                             "errorMsg": "Wrong job ID." }
        else:
            response = { "responseType": "ERROR",
                         "errorCode": 3,
                         "errorMsg": "Unkown request type." }
        return response

    def run(self):
        print(f"Starting RPC server of type {self.type}...")
        super(JobRPCServer, self).run()
