#!/usr/bin/env python

import json

from redis_rpc_server import RedisRPCServer
from config import Config
from db_connector import DbConnector
from job import Job
from job_queue import JobQueue


class StartJobRPCServer(RedisRPCServer):

    def __init__(self, host, port, db, rpcQueue):
        self.type = "start"
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("file_catalog")
        self.dbConn = DbConnector(self.params["user"],
                                  self.params["password"],
                                  self.params["host"],
                                  self.params.getint("port"),
                                  self.params["db"],
                                  8,
                                  16)
        self.params = config.loadSection("scheduling")
        self.maxPendingJobs = self.params.getint("max_pending_jobs")
        self.maxTerminatedJobs = self.params.getint("max_terminated_jobs")
        self.pendingQueueRead = JobQueue("read_pending")
        self.terminatedQueueRead = JobQueue("read_terminated")
        super(StartJobRPCServer, self).__init__(host, port, db, rpcQueue)

    def callback(self, requestBody):
        # debug block...
        out = open("start_job_amqp_server_log.txt", "a")
        out.write(json.dumps(requestBody))


        job = Job()
        job.setId(requestBody["job"]["jobId"])
        job.setType(requestBody["job"]["jobInfo"]["transfer"]["direction"])
        job.setInfo(requestBody["job"]["jobInfo"])
        job.setOwnerId(requestBody["job"]["ownerId"])
        if self.pendingQueueRead.len() >= self.maxPendingJobs:
            job.setPhase("ERROR")
            job.setErrorType("transient")
            job.setErrorMessage("Pending queue is full, please, retry later.")
            self.dbConn.insertJob(job)
            if self.terminatedQueueRead.len() == self.maxTerminatedJobs:
                    self.terminatedQueueRead.extractJob()
            self.terminatedQueueRead.insertJob(job)
        else:
            job.setPhase(requestBody["job"]["phase"])
            self.dbConn.insertJob(job)
            self.pendingQueueRead.insertJob(job)
        response = self.dbConn.getJob(job.jobId)

        # debug block...
        out.write(f"Db response: {response}")
        out.close()

        return response

    def run(self):
        print(f"Starting RPC server of type {self.type}...")
        super(StartJobRPCServer, self).run()
