#!/usr/bin/env python

from config import Config
from cli_handler import CliHandler
from job_scheduler import JobScheduler
from vospace_rest_handler import VOSpaceRestHandler


class TransferService(object):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        self.params = config.loadSection("job_cache")
        self.cliHandler = CliHandler(self.params["host"], self.params.getint("port"), self.params.getint("db_sched"))
        self.vosRestHandler = VOSpaceRestHandler(self.params["host"], self.params.getint("port"), self.params.getint("db_sched"))
        self.jobScheduler = JobScheduler()

        # PullToVOSpace (via REST API)
        self.vosRestHandler.addRPCServer('start', 'start_job_queue')
        self.vosRestHandler.addRPCServer('poll', 'poll_job_queue')
        self.vosRestHandler.addRPCServer('abort', 'abort_job_queue')

        # PushToVOSpace (via vos_data, the 'unofficial' command line client)
        self.cliHandler.addRPCServer('data', 'data_queue')       
        
        # Import
        self.cliHandler.addRPCServer('import', 'import_queue')
        
        # Job
        self.cliHandler.addRPCServer('job', 'job_queue')
        
        # Storage
        self.cliHandler.addRPCServer('storage', 'storage_queue')
        
        # Startup
        self.jobScheduler.start()
        self.vosRestHandler.start()
        self.cliHandler.start()

    def start(self):
        print("\nTransfer service is RUNNING...\n")
        

ts = TransferService()
ts.start()
